OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)

MEMORY {
	FLASH (rx) : ORIGIN = 0x40600000, LENGTH = 0x00100000
}

SECTIONS
{
        . = ALIGN(4);
	.text : { 
		_stext = .;
		*main.o (.text)
		*(.text)
		*(.glue_7t) *(.glue_7)
		. = ALIGN (4);
	} > FLASH

	. = ALIGN (4);

	.rodata : {
		*(.rodata)
	} > FLASH

	. = ALIGN(4);
	_etext = .;

	/* collect all initialized .data sections */
	.data : AT (_etext) { 
		_sdata = .;
		*(.vectors)
		*(.data)
		_edata = .;
	} > FLASH

	. = ALIGN(4);

	/* collect all uninitialized .bss sections */
	/*.bss (NOLOAD) : { */
	.bss : {
		. = ALIGN(4);
		_sbss = .;
		*(.bss)
		_ebss = .;
	} > FLASH
}
end = .;  /* define a global symbol marking the end of application */

PROVIDE(__HEAP_START = end);
