/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#ifndef _AT91SAM7A2_PIO_H_
#define _AT91SAM7A2_PIO_H_

#include "global.h"

typedef struct {

	REG32	PIO_RESERVED_A[4];
	
	REG32	PIO_OER;
	REG32	PIO_ODR;
	REG32	PIO_OSR;

	REG32	PIO_RESERVED_B[5];

	REG32	PIO_SODR;
	REG32	PIO_CODR;
	REG32	PIO_ODSR;
	REG32	PIO_PDSR;
	REG32	PIO_MDER;
	REG32	PIO_MDDR;
	REG32	PIO_MDSR;

	REG32	PIO_RESERVED_C;

	REG32	PIO_ECR;
	REG32	PIO_DCR;
	REG32	PIO_PMSR;

	REG32	PIO_RESERVED_D;
	
	REG32	PIO_CR;
	REG32	PIO_MR;

	REG32	PIO_RESERVED_E[2];

	REG32	PIO_SR;
	REG32	PIO_IER;
	REG32	PIO_IDR;
	REG32	PIO_IMR;

}AT91SAM7A2_PIO;

#define PIO_BASE_ADDR	0xFFFD8000

#define PIO_CR_SWRST	BIT0
#define PIO_ECR_CKEN	BIT0

void at91sam7a2_pio_init();
void at91sam7a2_pio_init_pin(unsigned char);
void at91sam7a2_pio_set_pin(unsigned char);
void at91sam7a2_pio_clear_pin(unsigned char);
unsigned char at91sam7a2_pio_input_level(unsigned char);

#endif

