/**
 *   ____                           _      ____
 *  / ___|___  _ __   ___ ___ _ __ | |_   / ___|__ _ _ __
 * | |   / _ \| '_ \ / __/ _ \ '_ \| __| | |   / _` | '__|
 * | |__| (_) | | | | (_|  __/ |_) | |_  | |__| (_| | |
 *  \____\___/|_| |_|\___\___| .__/ \__|  \____\__,_|_|
 *                           |_|
 *
 * (c) 2008 Fraunhofer IESE, Kaiserslautern, Germany
 *
 * This code is provided as-is, with no special warranty that it
 * works as expected or works at all. Though it has been tested
 * in daily use and has not failed us yet.
 * Nevertheless, your mileage may vary.
 *
 * You are free and welcome to copy, change and use this code in
 * any way you wish, as long as this header and the copyright
 * notice remain intact. Have fun.
 */

/**
 * This file holds a list with all the IDs used at the concept
 * car's CAN bus.
 * Furthermore the codes for the error messages are provided.
 */
#ifndef _CANIDS_H_
#define _CANIDS_H_

// CAN IDs
#define CANID_WHEELSPEED_FL             0x008
#define CANID_WHEELSPEED_FR             0x009
#define CANID_WHEELSPEED_RL             0x00a
#define CANID_WHEELSPEED_RR             0x00b
#define CANID_VOLTAGE                   0x00d
#define CANID_RESETCOUNTER              0x00e
#define CANID_INERTIAL_AX               0x010
#define CANID_INERTIAL_AY               0x011
#define CANID_ROTATION                  0x012
#define CANID_SELECTJUMPER              0x020
#define CANID_THROTTLE                  0x022
#define CANID_THROTTLE_ARM7             0x122
#define CANID_STEERING                  0x025
#define CANID_STEERING_ARM7             0x125
#define CANID_DISTANCE                  0x030
#define CANID_ERROR                     0x400
#define CANID_EMERGENCY                 0x402

//Free CAN ID's for Quartz
#define CANID_QUARTZ_INPUT1	0X200
#define CANID_QUARTZ_INPUT2	0X201
#define CANID_QUARTZ_INPUT3	0X202
#define CANID_QUARTZ_OUTPUT1	0X210
#define CANID_QUARTZ_OUTPUT2	0X211
#define CANID_QUARTZ_OUTPUT3	0X212


// Error IDs (for CANID_ERROR telegrams)
#define ERRORID_PWM_OUTOFBOUNDS                 0x01
#define ERRORID_PWM_FREQUENCY                   0x02
#define ERRORID_RECEIVER_NOSIGNAL               0x03
#define ERRORID_ACTOR                           0x07
#define ERRORID_DISTANCE_SENSOR1_NOTPLUGGED     0x10
#define ERRORID_DISTANCE_SENSOR1_NOTWORKING     0x11
#define ERRORID_DISTANCE_SENSOR2_NOTPLUGGED     0x12
#define ERRORID_DISTANCE_SENSOR2_NOTWORKING     0x13
#define ERRORID_DISTANCE_HEARTBEAT_TIMEOUT      0x14
#define ERRORID_DISTANCE_MASTER_OFF             0x15
#define ERRORID_DISTANCE_I2C_MASTER_OFF         0x16
#define ERRORID_DISTANCE_I2C_SLAVE_OFF          0x17
#define ERRORID_DISTANCE_I2C_SENSOR_OFF         0x18

#endif // _CANIDS_H_

