/* ************************************************************************** */
/*                                                                            */
/*    eses                   eses                                             */
/*   eses                     eses                                            */
/*  eses    eseses  esesese    eses   Embedded Systems Group                  */
/*  ese    ese  ese ese         ese                                           */
/*  ese    eseseses eseseses    ese   Department of Computer Science          */
/*  eses   eses          ese   eses                                           */
/*   eses   eseses  eseseses  eses    University of Kaiserslautern            */
/*    eses                   eses                                             */
/*                                                                            */
/* ************************************************************************** */


#include "can.h"						//This is the header file that includes all the CAN function declarations
#include "at91sam7a2_interrupts.h"		//This is the header file that includes the timer and delay function declarations
#include "canids.h"						//Contains all the valid CAN identifiers
#include "util.h"						//Configures LED pin
#include "at91sam7a2_timers.h"


/*ECU specific read CAN functions (based on ECU specific CAN ID's (see canids.h)*/
/*These methods are defined for the purpose of receiving data
from specific ECU's as depicted by names*/
#define READ_WHEELSPEED_FR_DATA(WHEELSPEED_FR_DATA) \
        {\
           can_receive(CHANNEL0, &WHEELSPEED_FR_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_WHEELSPEED_FL_DATA(WHEELSPEED_FL_DATA) \
        ({\
           can_receive(CHANNEL1, &WHEELSPEED_FL_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        })

#define READ_WHEELSPEED_RR_DATA(WHEELSPEED_RR_DATA) \
        {\
           can_receive(CHANNEL2, &WHEELSPEED_RR_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_WHEELSPEED_RL_DATA(WHEELSPEED_RL_DATA) \
        {\
           can_receive(CHANNEL3, &WHEELSPEED_RL_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_THROTTLE_DATA(THROTTLE_DATA)  \
        {\
           can_receive(CHANNEL4, &THROTTLE_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_STEERING_DATA(STEERING_DATA) \
        {\
           can_receive(CHANNEL5, &STEERING_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_INERTIAL_AX_DATA(INERTIAL_AX_DATA) \
        {\
           can_receive(CHANNEL6, &INERTIAL_AX_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }


#define READ_INERTIAL_AY_DATA(INERTIAL_AY_DATA) \
        {\
           can_receive(CHANNEL7, &INERTIAL_AY_DATA, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

/*User defined read CAN functions*/
/*These methods allow the user to receive messages from the predefined ID's (see canids.h)
other then ECU specific ID's*/
#define READ_INPUT1(value) \
        {\
           can_receive(CHANNEL8, &value, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_INPUT2(value) \
        {\
           can_receive(CHANNEL9, &value, INTERRUPT_MODE);\
		    delay_ms(1);\
        }

#define READ_INPUT3(value) \
        {\
           can_receive(CHANNEL10, &value, INTERRUPT_MODE);\
		    delay_ms(1);\
        }


/*configures the LED on the ARM board, with initial state LED turned off*/
#define Initialize_LED() \
{\
util_config_led(2); \
util_set_led(); \
}

/*Initializes the ARM board timer*/
#define Initialize_Timer()	{config_delay_ms();}

/*Initializes the CAN bus (activates the bus)*/
#define Initialize_CAN_Module()	{can_init();}
/*Initializes the CAN bus for reception and transmission*/
#define Initialize_CAN_Channels()	{Configure_CAN_Channels();}
/*Initializes all the desired peripherals*/
#define Init_Peripheral() \
{\
Initialize_LED(); \
Initialize_Timer(); \
Initialize_CAN_Module(); \
Initialize_CAN_Channels(); \
}

/*flashes the LED (LED times)*/
#define WRITE_LED2(LED)  {blink_led(LED);}

#define debug_led()  {blink_led(2);}		//just for debugging

/*ECU specific write CAN functions (based on ECU specific CAN ID's (see canids.h)*/
/*These methods are defined for the purpose of transmitting data
for specific ECU's as depicted by names*/
#define WRITE_ARM_THROTTLE_DATA(value) {can_send(CANID_THROTTLE_ARM7,value);}
#define WRITE_WHEELSPEED_RL_DATA(value) {can_send(CANID_WHEELSPEED_RL,value);}
#define WRITE_WHEELSPEED_RR_DATA(value) {can_send(CANID_WHEELSPEED_RR,value);}
#define WRITE_WHEELSPEED_FL_DATA(value) {can_send(CANID_WHEELSPEED_FL,value);}
#define WRITE_WHEELSPEED_FR_DATA(value) {can_send(CANID_WHEELSPEED_FR,value);}

/*User defined write CAN functions*/
/*These methods allow the user to transmit messages on the predefined ID's (see canids.h)
other then ECU specific ID's*/
#define WRITE_OUTPUT1_DATA(value) {can_send(CANID_QUARTZ_OUTPUT1,value);}
#define WRITE_OUTPUT2_DATA(value) {can_send(CANID_QUARTZ_OUTPUT2,value);}
#define WRITE_OUTPUT3_DATA(value) {can_send(CANID_QUARTZ_OUTPUT3,value);}

/*exceptional write CAN function1*/
/*This is exceptional CAN write function that allows the user to transmit the message 
on any selected ID (should be provided as an argument "id")*/
#define WRITE_OUTPUT_DATA(id, value) {can_send(id, value);}

/*exceptional write CAN function2*/
/*This is exceptional CAN write function that allows the user to transmit the "address" of the message 
on any selected ID (should be provided as an argument "id")*/
#define WRITE_OUTPUTByMEMORY_DATA(id, value) {can_send(id, encode_speed_data(value));}

/*Same as above, except with a fixed id*/
#define WRITE_OUTPUT1ByMEM_DATA(value) {can_send(CANID_SPEED_MS, encode_speed_data(value));}

#define STEP_FINISHED() {0;}
