/*
 * at91sam7a2_ExternalInterrupts.cpp
 *
 *  Created on: Feb 26, 2012
 *      Author: Omair
 */

#include "at91sam7a2_ExternalInterrupts.h"
#include "util.h"
//#include "at91sam7a2_pio.h"


/**
 * The Interrupt service routine for handling the External-Interrupts (IRQ0).
 *
 * executes this routine whenever a negative edge signal arrives at IRQ0 (
 */
__attribute__((interrupt("IRQ"))) void _ext0ISR() {
	util_clear_led();
	at91sam7a2_end_of_interrupt ();
}

__attribute__((interrupt("IRQ"))) void _ext1ISR() {
	util_clear_led();
	at91sam7a2_end_of_interrupt ();
}



void init_ext_interrupts(unsigned char count)
{
	//enable ext interrupt(s)
	if(count==0)	//enable IRQ0 only
	{
		at91sam7a2_interrupts_configure_prior_srctyp (0,IRQ_IRQ0, 1, 0); //highest priority, negative edge triggered
		at91sam7a2_interrupts_configure_source(_ext0ISR, IRQ_IRQ0);	//
		at91sam7a2_interrupts_enable(IRQ_IRQ0);
	}

	else if(count==1) //enable IRQ1 only
	{
		at91sam7a2_interrupts_configure_prior_srctyp (0,IRQ_IRQ1, 1, 0); //highest priority, negative edge triggered
		at91sam7a2_interrupts_configure_source(_ext1ISR, IRQ_IRQ1);	//
		at91sam7a2_interrupts_enable(IRQ_IRQ0);
	}

	else if(count==2)	//enable IRQ0 and IRQ1
	{
		at91sam7a2_interrupts_configure_prior_srctyp (0,IRQ_IRQ0, 1, 0); //highest priority, negative edge triggered
		at91sam7a2_interrupts_configure_prior_srctyp (1,IRQ_IRQ1, 1, 0); //2nd highest priority, negative edge triggeredat91sam7a2_interrupts_configure_source(_ext1ISR, IRQ_IRQ0);
		at91sam7a2_interrupts_configure_source(_ext0ISR, IRQ_IRQ0);		//ISR for interrupt 0
		at91sam7a2_interrupts_configure_source(_ext1ISR, IRQ_IRQ1);		//ISR for interrupt 1
		at91sam7a2_interrupts_enable(IRQ_IRQ0);
		at91sam7a2_interrupts_enable(IRQ_IRQ1);
	}

}
