/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#include "at91sam7a2_pio.h"

AT91SAM7A2_PIO *pio = (AT91SAM7A2_PIO *)PIO_BASE_ADDR;

/**
 * Enables the PIO block by reseting it and enabling the
 * PIO clock
 */
void at91sam7a2_pio_init (void) {
	pio->PIO_CR = 1<<PIO_CR_SWRST; //soft reset PIO
	pio->PIO_ECR = 1<<PIO_ECR_CKEN; //enable PIO
}

/**
 * enables the specifc PIO pin for output
 *
 * @param pin PIO pin which is going to be enabled
 */
void at91sam7a2_pio_init_pin (unsigned char pin) {
	pio->PIO_MDDR |= 1<<pin; //not open drain (which pin?)
	pio->PIO_OER |= 1<<pin; //enable output pin (which pin?)
}

/**
 * set the value for the pin specified by pin
 *
 * @param pin the pin whose value is being set
 */
void at91sam7a2_pio_set_pin (unsigned char pin) {
	pio->PIO_SODR |= 1<<pin;
}

/**
 * clear the value of the given pin
 *
 * @param pin the pin whose value is bein cleared
 */
void at91sam7a2_pio_clear_pin (unsigned char pin) {
	pio->PIO_CODR |= 1<<pin;
}

unsigned char at91sam7a2_pio_input_level (unsigned char pin) {
	if(!(pio->PIO_PDSR & pin))
		return(1);

	return(0);
}

