/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#ifndef AT91SAM7A2_TIMERS_H_
#define AT91SAM7A2_TIMERS_H_

#include "global.h"

#define GPT_TIMER_BASE_ADDRESS		0xfffc8000
#define GPT_SCHEDULER_BASE_ADDRESS 	0xfffcc000

typedef struct {

	REG32	GPT_PER;
	REG32	GPT_PDR;
	REG32	GPT_PSR;

	REG32	reserved;

	REG32	GPT_OER;
	REG32	GPT_ODR;
	REG32	GPT_OSR;

	REG32	reserved2[5];

	REG32	GPT_SODR;
	REG32	GPT_CODR;
	REG32	GPT_ODSR;

	REG32	GPT_PDSR;
	REG32	GPT_MDER;
	REG32	GPT_MDDR;
	REG32	GPT_MDSR;

	REG32	reserved3;

	REG32	GPT_ECR;
	REG32	GPT_DCR;
	REG32	GPT_PMSR;

	REG32	reserved4;

	REG32	GPT_CR;
	REG32	GPT_MR;

	REG32	reserved5[2];

	REG32	GPT_SR;
	REG32	GPT_IER;
	REG32	GPT_IDR;
	REG32	GPT_IMR;

	REG32	GPT_CV;
	REG32	GPT_RA;
	REG32	GPT_RB;
	REG32	GPT_RC;

	REG32	padding[28];

}AT91SAM7A2_TIMER_CHANNEL;

typedef struct {
	AT91SAM7A2_TIMER_CHANNEL ch[3];
	REG32	GPT_BCR;
	REG32	GPT_BMR;
}AT91SAM7A2_TIMER;

typedef struct {
	AT91SAM7A2_TIMER_CHANNEL ch;
	volatile unsigned char vvoid [200];
	REG32	GPT_BCR;
	REG32	GPT_BMR;
}AT91SAM7A2_SCHEDULER;

#define GPT_TC		BIT1
#define GPT_PIO		BIT0

#define GPT_SWTRG	BIT3
#define GPT_CLKDIS	BIT2
#define GPT_CLKEN	BIT1
#define GPT_SWRST	BIT0

#define GPT_CLKS	BIT0
#define GPT_CLKI	BIT3
#define GPT_BURST	BIT4

#define GPT_LDBSTOP	BIT6
#define GPT_LDBIS	BIT7
#define GPT_ETRGEDG	BIT8

#define GPT_ABTRG	BIT10
#define GPT_CPCTRG	BIT14
#define GPT_WAVE	BIT15

#define GPT_LDRA	BIT16
#define GPT_LDRB	BIT18

#define GPT_COVFS	BIT0
#define GPT_LOVRS	BIT1
#define GPT_CPCS	BIT4
#define GPT_LDRAS	BIT5
#define GPT_LDRBS	BIT6
#define GPT_ETRGS	BIT7
#define GPT_CLKSTA	BIT8
#define GPT_MTIOA	BIT9
#define GPT_MTIOB	BIT10
#define GPT_TIOBS	BIT16
#define GPT_TIOAS	BIT17
#define GPT_TCLKS	BIT18

#define GPT_CPCSTOP	BIT6
#define GPT_CPCDIS	BIT7
#define GPT_EEVTEDG	BIT8
#define GPT_EEVT	BIT10
#define GPT_ENETRG	BIT12
#define GPT_CPCTRG	BIT14

#define GPT_ACPA	BIT16
#define GPT_ACPC	BIT18
#define GPT_AEEVT	BIT20
#define GPT_ASWTRG	BIT22
#define GPT_BCPB	BIT24
#define GPT_BCPC	BIT26
#define GPT_BEEVT	BIT28
#define GPT_BSWTRG	BIT30

#define CORECLK_2	0x00
#define CORECLK_8	0x01
#define CORECLK_32	0x02
#define CORECLK_128	0x03
#define CORECLK_1024	0x04

#define GPT_RC_MILLISEC	(CORECLK/1024/1000)

void at91sam7a2_timers_config_as_scheduler (unsigned int);
void at91sam7a2_timers_config_as_alarm (unsigned int, volatile unsigned char *);
void at91sam7a2_timers_config_freerun ();
unsigned long at91sam7a2_timers_get_systime ();
void at91sam7a2_scheduler_config(unsigned int);
void delay_ms(int);
void config_delay_ms();
void timer_led_interrupt(int);
void blink_led(unsigned int);
#endif
