/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#define lock__ __asm__ __volatile__ ("1:\n\tb 1b");

#define REG32		volatile long
#define REG32_PTR	(volatile long *)

#define BIT0	0
#define BIT1	1
#define BIT2	2
#define BIT3	3
#define BIT4	4
#define BIT5	5
#define BIT6	6
#define BIT7	7
#define BIT8	8
#define BIT9	9
#define BIT10	10
#define BIT11	11
#define BIT12	12
#define BIT13	13
#define BIT14	14
#define BIT15	15
#define BIT16	16
#define BIT17	17
#define BIT18	18
#define BIT19	19
#define BIT20	20
#define BIT21	21
#define BIT22	22
#define BIT23	23
#define BIT24	24
#define BIT25	25
#define BIT26	26
#define BIT27	27
#define BIT28	28
#define BIT29	29
#define BIT30	30
#define BIT31	31

#define PLL_MUL 0x0A

#define CORECLK (((6 * PLL_MUL) / 2) * 1000000)

/**
 * in order to handle an interrupt correctly, inside the IRQ we switch
 * to supervisor mode. That is because we need valid stack to call functions
 * inside the interrupt handler (e.g. the scheduler). After handling the
 * interrupt we must return to IRQ mode. The defines below do this for us.
 * They must be called prior to any function call inside the IRQ handler
 * and right before the call to at91sam7a2_interrupts_finish.
 */
#define IRQ2SVR	__asm__ __volatile__ ("mrs r8,CPSR \n\t push {r8} \n\t mov r8,#0x93 \n\t msr CPSR_c,r8")
#define SVR2IRQ	__asm__ __volatile__ ("mov r8,#0x92 \n\t msr CPSR_c,r8 \n\t pop {r8} \n\t msr CPSR_c,r8")


#endif
