/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#include "at91sam7a2_interrupts.h"

AT91SAM7A2_GIC *gic = (AT91SAM7A2_GIC *)GIC_BASE_ADDRESS;

/**
 * this function might be configured as the default handler to
 * manage interrupts.
 */
void __interrupt_request () {

	int irq_no = -1;
	irq_no = 0x1ff & (gic->GIC_ISR);

}

/**
 * this function can be configured as the default handler for
 * fast interrupts
 */
void __attribute__ ((interrupt("IRQ"))) __fast_interrupt_request () {
	int irq_no = -1;
	irq_no = gic->GIC_IVR;
	irq_no = 0x1ff & gic->GIC_ISR;
}

/**
 * initializes the GIC
 */
void at91sam7a2_interrupts_init () {
	int i = 0;
	for (;i<8;i++)
		gic->GIC_EOICR = 0x00;
}

/**
 * configures the address of a handler for a specific interrupt source
 * i.e. INT0, user_interrupt_handler
 *
 * @param addr address of the function that handles the interrupt request
 * @param source the source that triggers this handler (see datasheet)
 */
void at91sam7a2_interrupts_configure_source (void (*addr)(),unsigned int source) {
	gic->GIC_SVR[source]=(unsigned int)addr;
}

/**
 * configures the mode for a specific interrupt source
 *
 * @param mode configures the priority and interrupt source type (see datasheet)
 * @param source the source that triggers the interrupt request (i.e. WDT)
 */
void at91sam7a2_interrupts_configure_mode (unsigned int mode,unsigned int source) {
	gic->GIC_SMR[source] = mode;
}

void at91sam7a2_interrupts_configure_prior_srctyp (unsigned int prior,unsigned int source, unsigned int srctyp1, unsigned int srctyp2) {
	gic->GIC_SMR[source] = prior | srctyp1<<SRCTYP1 | srctyp2<<SRCTYP2  ;
}

/**
 * enables the interrupt given by irq (i.e. INT1)
 *
 * @param irq interrupt line being enabled
 */
void at91sam7a2_interrupts_enable (unsigned int irq) {
	gic->GIC_IECR |= 1<<irq;
}

/**
 * disables the interrupt given by irq
 *
 * @param irq interrupt line being disabled
 */
void at91sam7a2_interrupts_disable (unsigned int irq) {
	gic->GIC_IDCR |= 1<<irq;
}

/**
 * clears the interrupt flag for the given irq. when an interrupt
 * happens, the corresponding interrupt flag is set in the command
 * register. In order to signal the servicing, this flag must be cleared.
 *
 * @param irq interrupt whose flag is being cleared
 */
void at91sam7a2_interrupts_clear (unsigned int irq) {
	gic->GIC_ICCR |= 1<<irq;
}

void at91sam7a2_end_of_interrupt () {
	gic->GIC_EOICR = 0x1;
}

