/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#include "at91sam7a2_timers.h"
#include "at91sam7a2_interrupts.h"
#include "util.h"
AT91SAM7A2_TIMER *timer = (AT91SAM7A2_TIMER *)GPT_TIMER_BASE_ADDRESS;
AT91SAM7A2_SCHEDULER *scheduler = (AT91SAM7A2_SCHEDULER*) GPT_SCHEDULER_BASE_ADDRESS;



void timer_interrupt()
{
	if (timer->ch[1].GPT_SR & 1<<GPT_CPCS) {
			util_clear_led();

			timer->ch[1].GPT_CR = 1<<GPT_CLKEN | 1<<GPT_SWTRG;
		}

}

void config_delay_ms()
{

	timer->ch[0].GPT_ECR = 1<<GPT_TC;
		//reset
		timer->ch[0].GPT_CR = 1<<GPT_SWRST;
		//clock is core/1024 and triggers when CV = RC
		timer->ch[0].GPT_MR = CORECLK_1024<<GPT_CLKS | 1<<GPT_CPCTRG;

}


void delay_ms(int count)
{

		//configure RC for the delay
			timer->ch[0].GPT_RC = count*GPT_RC_MILLISEC;
		//start timer
			timer->ch[0].GPT_CR = 1<<GPT_CLKEN | 1<<GPT_SWTRG;

			while(!(timer->ch[0].GPT_SR & 1<<GPT_CPCS));

}


void timer_led_interrupt(int count)
{
	timer->ch[1].GPT_ECR = 1<<GPT_TC;
			//reset
			timer->ch[1].GPT_CR = 1<<GPT_SWRST;
			//clock is core/1024 and triggers when CV = RC
			timer->ch[1].GPT_MR = CORECLK_1024<<GPT_CLKS | 1<<GPT_CPCTRG;
			//configure RC for the delay
			timer->ch[1].GPT_RC = count*GPT_RC_MILLISEC;

			//configure interrupt
				timer->ch[1].GPT_IER = 1<<GPT_CPCS;

				//register handler in GIC
				at91sam7a2_interrupts_configure_source(timer_interrupt,IRQ_GPT0CH1);
				at91sam7a2_interrupts_configure_prior_srctyp(GPT1CH0_PRIOR, IRQ_GPT1CH0, 0 , 0);
				at91sam7a2_interrupts_enable(IRQ_GPT0CH1);

				//start timer
				timer->ch[1].GPT_CR = 1<<GPT_CLKEN | 1<<GPT_SWTRG;
}


void blink_led(unsigned int number_of_times)
{
	for(int i=0; i<number_of_times; i++)
	{
		util_set_led();
		delay_ms(100);
		util_clear_led();
		delay_ms(100);
	}
}
