/********************************************************
*   ____                           _    ____           	*
*  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __ 	*
* | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__|	*
* | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |   	*
*  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|   	*
*   Copyright 2005-2008     |_|  IESE Fraunhofer KL    	*
*							*
*							*
* @version 0.1						*
* @date 2008-10						*
*********************************************************/

#ifndef AT91SAM7A2_INTERRUPTS_H_
#define AT91SAM7A2_INTERRUPTS_H_

#include "global.h"

/****************************************************************
 * AT91SAM7A2 interrupt source table				*
 *								*
 *								*
 *								*
 *								*
 ***************************************************************/

#define GIC_BASE_ADDRESS	0xfffff000

typedef struct {

	REG32	GIC_SMR[32];
	REG32	GIC_SVR[32];

	REG32	GIC_IVR;
	REG32	GIC_FVR;
	REG32	GIC_ISR;
	REG32	GIC_IPR;
	REG32	GIC_IMR;
	REG32	GIC_CISR;

	REG32	GIC_RESERVED[2];

	REG32	GIC_IECR;
	REG32	GIC_IDCR;
	REG32	GIC_ICCR;
	REG32	GIC_ISCR;
	REG32	GIC_EOICR;
	REG32	GIC_SPU;

}AT91SAM7A2_GIC;

#define IRQ_FIQ		0
#define IRQ_SWIRQ0	1
#define IRQ_WD		2
#define IRQ_WT		3
#define IRQ_USART0	4
#define IRQ_USART1	5
#define IRQ_CAN3	6
#define IRQ_SPI		7
#define IRQ_CAN1	8
#define IRQ_CAN2	9
#define IRQ_ADC0	10
#define IRQ_ADC1	11
#define IRQ_GPT0CH0	12
#define IRQ_GPT0CH1	13
#define IRQ_GPT0CH2	14
#define IRQ_SWIRQ1	15
#define IRQ_SWIRQ2	16
#define IRQ_SWIRQ3	17
#define IRQ_GPT1CH0	18
#define IRQ_PWM		19
#define IRQ_CAN0	20
#define IRQ_UPIO	21
#define IRQ_CAPT0	22
#define IRQ_CAPT1	23
#define IRQ_ST0		24
#define IRQ_ST1		25
#define IRQ_SWIRQ4	26
#define IRQ_SWIRQ5	27
#define IRQ_IRQ0	28
#define IRQ_IRQ1	29
#define IRQ_SWIRQ6	30
#define IRQ_SWIRQ7	31

#define SRCTYP1 BIT5
#define SRCTYP2 BIT6

#define GPT1CH0_PRIOR 7

void __interrupt_request ();
void __fast_interrupt_request ();
void at91sam7a2_interrupts_init();
void at91sam7a2_interrupts_configure_source(void (*addr)(),unsigned int);
void at91sam7a2_interrupts_configure_mode (unsigned int,unsigned int);
void at91sam7a2_interrupts_configure_prior_srctyp (unsigned int, unsigned int , unsigned int, unsigned int);
void at91sam7a2_interrupts_enable (unsigned int);
void at91sam7a2_interrupts_disable (unsigned int);
void at91sam7a2_interrupts_clear (unsigned int); 
void at91sam7a2_interrupts_read_ivr ();
void at91sam7a2_end_of_interrupt ();

#endif
