/*
 * Application1.c
 *
 *  Created on: Sep 25, 2011
 *      Author: Omair
 */

#include "Application1.h"
#include "Application1_io.h"




void Application1(int __steps)
{
    /* declare variables */
    unsigned int WHEELSPEED_FL_DATA = 0;
    unsigned int WHEELSPEED_FR_DATA = 0;
    unsigned int WHEELSPEED_RL_DATA = 0;
    unsigned int WHEELSPEED_RR_DATA = 0;
    unsigned int THROTTLE_DATA = 0;
    unsigned int STEERING_DATA = 0;
    unsigned int ARM_THROTTLE_DATA = 0;
    unsigned int LED2 = 0;
    unsigned int __state000 = 0;

    /* initial state */
    {
        /* declare local event variables */
        int __lvar000 = 0;
        int __lvar004 = 0;

        /* read inputs */
        (READ_WHEELSPEED_FL_DATA(WHEELSPEED_FL_DATA));
        (READ_WHEELSPEED_FR_DATA(WHEELSPEED_FR_DATA));
        (READ_WHEELSPEED_RL_DATA(WHEELSPEED_RL_DATA));
        (READ_WHEELSPEED_RR_DATA(WHEELSPEED_RR_DATA));
        (READ_THROTTLE_DATA(THROTTLE_DATA));
        (READ_STEERING_DATA(STEERING_DATA));

        /* evaluate guarded actions */
        __lvar000 = (500 < THROTTLE_DATA);
        __lvar004 = ((__state000 == 1) && (__state000 == 2));
        __state000 = 1;

        /* write outputs */
        (WRITE_ARM_THROTTLE_DATA(ARM_THROTTLE_DATA));
        (WRITE_LED2(LED2));

        (STEP_FINISHED());
    }

    /* main loop */
    while(1)
    {
        switch(__state000)
        {
            case 1:
            {
                /* declare local event variables */
                int __lvar000 = 0;
                int __lvar004 = 0;

                /* read inputs */
                (READ_WHEELSPEED_FL_DATA(WHEELSPEED_FL_DATA));
                (READ_WHEELSPEED_FR_DATA(WHEELSPEED_FR_DATA));
                (READ_WHEELSPEED_RL_DATA(WHEELSPEED_RL_DATA));
                (READ_WHEELSPEED_RR_DATA(WHEELSPEED_RR_DATA));
                (READ_THROTTLE_DATA(THROTTLE_DATA));
                (READ_STEERING_DATA(STEERING_DATA));

                /* evaluate guarded actions */
                LED2 = 1;
                __lvar000 = (500 < THROTTLE_DATA);
                if(__lvar000) {
                    ARM_THROTTLE_DATA = 0;
                }
                if((! __lvar000)) {
                    ARM_THROTTLE_DATA = THROTTLE_DATA;
                }
                __lvar004 = ((__state000 == 1) && (__state000 == 2));
                __state000 = 2;

                /* write outputs */
                (WRITE_ARM_THROTTLE_DATA(ARM_THROTTLE_DATA));
                (WRITE_LED2(LED2));

                (STEP_FINISHED());
            }
            break;

            case 2:
            {
                /* declare local event variables */
                int __lvar000 = 0;
                int __lvar004 = 0;

                /* read inputs */
                (READ_WHEELSPEED_FL_DATA(WHEELSPEED_FL_DATA));
                (READ_WHEELSPEED_FR_DATA(WHEELSPEED_FR_DATA));
                (READ_WHEELSPEED_RL_DATA(WHEELSPEED_RL_DATA));
                (READ_WHEELSPEED_RR_DATA(WHEELSPEED_RR_DATA));
                (READ_THROTTLE_DATA(THROTTLE_DATA));
                (READ_STEERING_DATA(STEERING_DATA));

                /* evaluate guarded actions */
                LED2 = 2;
                __lvar000 = (500 < THROTTLE_DATA);
                __lvar004 = ((__state000 == 1) && (__state000 == 2));
                __state000 = 1;

                /* write outputs */
                (WRITE_ARM_THROTTLE_DATA(ARM_THROTTLE_DATA));
                (WRITE_LED2(LED2));

                (STEP_FINISHED());
            }
            break;
        }

        /* check for stopping */
        if(__steps > 0) __steps --;
        if(__steps == 0) return;
    }
}
