/********************************************************
 *   ____                           _    ____            *
 *  / ___|___  _ __   ___ ___ _ __ | |_ / ___|__ _ _ __  *
 * | |   / _ \| '_ \ / __/ _ \ '_ \| __| |   / _` | '__| *
 * | |__| (_) | | | | (_|  __/ |_) | |_| |__| (_| | |    *
 *  \____\___/|_| |_|\___\___| .__/ \__|\____\__,_|_|    *
 *   Copyright 2005-2009     |_|  Fraunhofer IESE KL     *
 *                                                       *
 *                                                       *
 * @version 0.4	                                         *
 * @date 2009-08                                         *
 *********************************************************/

#ifndef CAN_H_
#define CAN_H_

#include "global.h"
#include <inttypes.h>

#define CAN0_BASE_ADDRESS	0xfffd4000
#define CAN0_MAX_CHANNELS	16
#define CAN1_BASE_ADDRESS	0xfffb8000
#define CAN1_MAX_CHANNELS	16
#define CAN2_BASE_ADDRESS	0xfffbc000
#define CAN2_MAX_CHANNELS	32
#define CAN3_BASE_ADDRESS	0xfffb0000
#define CAN3_MAX_CHANNELS	16

#define CAN_CHANNELS		32
#define CAN_MODULE_PADDING

typedef struct {
	REG32 rsvd[5];
	REG32 CAN_DRA;
	REG32 CAN_DRB;
	REG32 CAN_MSK;
	REG32 CAN_IR;
	REG32 CAN_CR;
	REG32 CAN_STP;
	REG32 CAN_CSR;
	REG32 CAN_SR;
	REG32 CAN_IER;
	REG32 CAN_IDR;
	REG32 CAN_IMR;
} AT91SAM7A2_CAN_CHANNEL;

typedef struct {
	REG32 rsvd[20];
	REG32 CAN_ECR;
	REG32 CAN_DCR;
	REG32 CAN_PMSR;

	REG32 rsvd1;

	REG32 CAN_CR;
	REG32 CAN_MR;

	REG32 rsvd2;

	REG32 CAN_CSR;
	REG32 CAN_SR;
	REG32 CAN_IER;
	REG32 CAN_IDR;
	REG32 CAN_IMR;

	REG32 CAN_CISR;
	REG32 CAN_ISSR;
	REG32 CAN_SIER;
	REG32 CAN_SIDR;
	REG32 CAN_SIMR;

	REG32 rsvd3[22];

	AT91SAM7A2_CAN_CHANNEL ch[CAN_CHANNELS];

} AT91SAM7A2_CAN_MODULE;

#define CAN_ENABLE	BIT1
#define CAN_SWRST	BIT0
#define CAN_CANEN	BIT1
#define CAN_CANDIS	BIT2
#define CAN_ABEN	BIT3
#define CAN_ABDIS	BIT4
#define CAN_OVEN	BIT5
#define CAN_OVDIS	BIT6

#define CAN_QUANTUM	BIT0 /* qt = (bd+1)/coreclock */
#define CAN_PROP	BIT8
#define CAN_SJW		BIT12
#define CAN_SMP		BIT14
#define CAN_PHSEG1	BIT16
#define CAN_PHSEG2	BIT20

#define CAN_ENDINIT	BIT2

#define CAN_CANENA	BIT0
#define CAN_CANINIT	BIT1
#define CAN_ENDINIT	BIT2
#define CAN_ERPAS	BIT3
#define CAN_BUSOFF	BIT4
#define CAN_ABRQ	BIT5
#define CAN_OVRQ	BIT6
#define CAN_ISS		BIT7
#define CAN_REC		BIT16
#define CAN_TEC		BIT24

#define CAN_CH0		BIT0
#define CAN_CH1		BIT1
#define CAN_CH2		BIT2
#define CAN_CH3		BIT3
#define CAN_CH4		BIT4
#define CAN_CH5		BIT5
#define CAN_CH6		BIT6
#define CAN_CH7		BIT7
#define CAN_CH8		BIT8
#define CAN_CH9		BIT9
#define CAN_CH10	BIT10
#define CAN_CH11	BIT11
#define CAN_CH12	BIT12
#define CAN_CH13	BIT13
#define CAN_CH14	BIT14
#define CAN_CH15	BIT15
#define CAN_CH16	BIT16
#define CAN_CH17	BIT17
#define CAN_CH18	BIT18
#define CAN_CH19	BIT19
#define CAN_CH20	BIT20
#define CAN_CH21	BIT21
#define CAN_CH22	BIT22
#define CAN_CH23	BIT23
#define CAN_CH24	BIT24
#define CAN_CH25	BIT25
#define CAN_CH26	BIT26
#define CAN_CH27	BIT27
#define CAN_CH28	BIT28
#define CAN_CH29	BIT29
#define CAN_CH30	BIT30
#define CAN_CH31	BIT31

#define CAN_MRTR	BIT31
#define CAN_MRB		BIT29

#define CAN_RTR		BIT31
#define CAN_RB		BIT29

#define CAN_OVERWRITE	BIT8
#define CAN_CHANEN	BIT7
#define CAN_PCB		BIT6
#define CAN_RPLYV	BIT5
#define CAN_IDE		BIT4
#define CAN_DLC		BIT0

#define CAN_OVRUN	BIT11
#define CAN_FILLED	BIT10
#define CAN_DLCW	BIT9
#define CAN_RFRAME	BIT7
#define CAN_TXOK	BIT6
#define CAN_RXOK	BIT5
#define CAN_BUS		BIT4
#define CAN_STUFF	BIT3
#define CAN_CRC		BIT2
#define CAN_FRAME	BIT1
#define CAN_ACK		BIT0

#define CHANNEL0	0
#define CHANNEL1	1
#define CHANNEL2	2
#define CHANNEL3	3
#define CHANNEL4	4
#define CHANNEL5	5
#define CHANNEL6	6
#define CHANNEL7	7
#define CHANNEL8	8
#define CHANNEL9	9
#define CHANNEL10	10
#define CHANNEL11	11

#define INTERRUPT_MODE 1
#define POLLING_MODE 0

#define MASK 0

/* 30 MHz */
#if (PLL_MUL == 0x0A)
#define BD 1
#define PHSEG1 3
#define PHSEG2 3
#define PROP 5
#define SJW 2
#endif
/* 48 MHz */
#if (PLL_MUL == 0x10)
#define BD 2
#define PHSEG1 3
#define PHSEG2 3
#define PROP 6
#define SJW 2
#endif

typedef struct {
	volatile unsigned int id;
	volatile unsigned int length;
	volatile unsigned int bufferHigh;
	volatile unsigned int bufferLow;
	volatile unsigned int ready;
	volatile unsigned long ts;
} CAN_BUFFER;

void can_init(void);
void can_subscribeID(unsigned int id);

int can_receive(unsigned int , unsigned int* buf, short);
unsigned long can_receiveTimestamp(unsigned int id);

int can_send(unsigned int id, unsigned int data);
void configure_can_channel(unsigned int, unsigned int, unsigned int, short);
void Configure_CAN_Channels();
float calculate_time_duration(unsigned int);
uint32_t encode_speed_data(float);

#endif /* CAN_H_ */
