/* ************************************************************************** */
/*                                                                            */
/*    eses                   eses                                             */
/*   eses                     eses                                            */
/*  eses    eseses  esesese    eses   Embedded Systems Group                  */
/*  ese    ese  ese ese         ese                                           */
/*  ese    eseseses eseseses    ese   Department of Computer Science          */
/*  eses   eses          ese   eses                                           */
/*   eses   eseses  eseseses  eses    University of Kaiserslautern            */
/*    eses                   eses                                             */
/*
 * author: Omair                                                                */
/* ************************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "can.h"
#include "util.h"
#include "at91sam7a2_interrupts.h"
#include "at91sam7a2_timers.h"
#include "canids.h"
#include <inttypes.h>
#include <Math.h>

volatile unsigned char step_flag = 0;
#define LED	2	//led pin on PIO bus
int main(); // main prototype

#define INTERVAL 500
#define PI 3.142

uint32_t output = 0x00000FEF;
uint8_t first_byte = 0;
unsigned int Timer_Resolution = 2000000; //16mhz/8 (prescaler = 8)
float radius = 0.06; //radius in meters. d = 12 cm
float speed_ms = 0.0f;
uint32_t speed_ms_encoded = 0;
float pulse_time_average = 0.0f;
float pulse_time_FR = 0.0f;
float pulse_time_FL = 0.0f;
float pulse_time_RR = 0.0f;
float pulse_time_RL = 0.0f;


/**
 * This function should always be the first function of the file!!
 */

void __attribute__ ((naked)) mmm() {
	__asm__ __volatile__ (".globl _start \n\t _start:");
	main();
}


int main() {

	unsigned int WHEELSPEED_FL_DATA;
	unsigned int WHEELSPEED_FR_DATA = 0;
	unsigned int WHEELSPEED_RL_DATA;
	unsigned int WHEELSPEED_RR_DATA;


	// initialize LED
	util_config_led(LED);
	util_clear_led();

	//Initialize Timer
	config_delay_ms();
	at91sam7a2_interrupts_init();


	// initialize CAN bus
	can_init();
	Configure_CAN_Channels();

	while (1) {

		can_receive(CHANNEL1, &WHEELSPEED_FR_DATA, INTERRUPT_MODE);
		can_receive(CHANNEL2, &WHEELSPEED_FL_DATA, INTERRUPT_MODE);
		can_receive(CHANNEL3, &WHEELSPEED_RR_DATA, INTERRUPT_MODE);
		can_receive(CHANNEL4, &WHEELSPEED_RL_DATA, INTERRUPT_MODE);

		//find definition of these function in "can.c"
		pulse_time_FR = calculate_time_duration(WHEELSPEED_FR_DATA);
		pulse_time_FL = calculate_time_duration(WHEELSPEED_FL_DATA);
		pulse_time_RR = calculate_time_duration(WHEELSPEED_RR_DATA);
		pulse_time_RL = calculate_time_duration(WHEELSPEED_RL_DATA);
		pulse_time_average = (pulse_time_FR + pulse_time_FL + pulse_time_RR + pulse_time_RL) / 4;

		/*Wheel speed Calculation Formula
		 * RPM = 60*Timer_Resolution(hertz)/pulse_time*26
		 * Wheel Speed(m/s) = (RPM * circumference) / 60
		 * */

		if(pulse_time_average != 0)
			speed_ms = ((Timer_Resolution * 2 * PI * radius) / (pulse_time_average * 26));
		else speed_ms = 0;
		speed_ms_encoded = encode_speed_data(speed_ms);	//encodes float in a compatible form before sending
		can_send(CANID_SPEED_MS ,speed_ms_encoded);

		blink_led(1);
	}

	return 0;
}
