<?xml version="1.1" encoding="utf-8" ?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:conf="http://es.cs.uni-kl.de/2009/RRTS/Conf">
	<xsl:output method="text" encoding="utf-8" />

	<!-- 	Includes header files needed by sensors/motors/etc.. Are always included, also if no motor is attached
		(it doesn't increase code size) 	-->
	<xsl:variable name="includes" select="
		'conio.h','unistd.h', 'dbutton.h', 'dsensor.h', 'dmotor.h', 'sys/tm.h', 'rom/system.h'" />


	<!--	"Main" method of this xslt file. Inputs the defined headers and invokes some write functions defined below.  -->
	<xsl:template match="/module">

		<xsl:variable name="name" select="@name" />
		<xsl:variable name="cap-name" select="upper-case($name)" />

		<xsl:text>#ifndef __</xsl:text><xsl:value-of select="$cap-name" /><xsl:text>_IO__H__&#10;</xsl:text>
		<xsl:text>#define __</xsl:text><xsl:value-of select="$cap-name" /><xsl:text>_IO__H__&#10;&#10;</xsl:text>

		<xsl:for-each select="$includes">
			<xsl:text>#include &lt;</xsl:text><xsl:value-of select="." /><xsl:text>&gt;&#10;</xsl:text>
		</xsl:for-each>

		<xsl:text>&#10;#include &lt;</xsl:text><xsl:value-of select="$name" /><xsl:text>.h&gt;&#10;&#10;</xsl:text>

		<xsl:variable name="params" select="conf:process-params(param)" />

		<xsl:call-template name="conf:io-defines"><xsl:with-param name="params" select="$params" /></xsl:call-template>

		<xsl:call-template name="conf:main">
			<xsl:with-param name="params" select="$params" />
			<xsl:with-param name="name" select="$name" />
		</xsl:call-template>

		<xsl:text>#endif&#10;</xsl:text>
	</xsl:template>

	<!-- Defines how sensor data is collected from BrickOS and how motor values are set so that BrickOS adjusts the motors -->
	<xsl:function name="conf:process-params">
		<xsl:param name="params" />

		<xsl:for-each select="$params" >
			<xsl:element name="param">
				<xsl:attribute name="name" select="@name" />
				<xsl:attribute name="type" select="@type" />
				<xsl:attribute name="datatype" select="'int'" />
				<xsl:attribute name="port" select="@port" />

				<!-- Touch sensor -->
				<xsl:if test="@type = 'touch'" >
					<xsl:attribute name="dir" select="'in'" />
					<xsl:attribute name="read" select="concat('TOUCH_', @port)" />
				</xsl:if>

				<!-- Light sensor -->
				<xsl:if test="@type = 'light'" >
					<xsl:if test="@active = 'true'">
						<xsl:attribute name="active" select="'true'" />
					</xsl:if>
					<xsl:attribute name="dir" select="'in'" />
					<xsl:attribute name="read" select="concat('LIGHT_', @port)" />
				</xsl:if>

				<!-- Rotation sensor -->
				<xsl:if test="@type = 'rotation'" >
					<xsl:attribute name="dir" select="'in'" />
					<xsl:attribute name="read" select="concat('ROTATION_', @port)" />
				</xsl:if>

				<!-- Motor speed -->
				<xsl:if test="@type = 'motor-speed'" >
					<xsl:attribute name="dir" select="'out'" />
					<xsl:attribute name="write" select="concat('motor_', @port, '_speed')" />
				</xsl:if>

				<!-- Motor rotation direction -->
				<xsl:if test="@type = 'motor-dir'" >
					<xsl:attribute name="dir" select="'out'" />
					<xsl:attribute name="write" select="concat('motor_', @port, '_dir')" />
				</xsl:if>

				<!-- LCD output that might help with debugging -->
				<!--<xsl:if test="@type = 'lcd'" >
					<xsl:attribute name="type"><xsl:value-of select="@type" /></xsl:attribute>
					<xsl:if test="@datatype = 'int'" >
						<xsl:attribute name="datatype">unsigned int</xsl:attribute>
					</xsl:if>
					<xsl:if test="@datatype = 'string'" >
						<xsl:attribute name="datatype">char*</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="dir">out</xsl:attribute>
					<xsl:attribute name="name">lcd_value</xsl:attribute>
					<xsl:if test="@datatype = 'int'" >
						<xsl:attribute name="write">lcd_unsigned</xsl:attribute>
					</xsl:if>
					<xsl:if test="@datatype = 'string'" >
						<xsl:attribute name="write">cputs</xsl:attribute>
					</xsl:if>
				</xsl:if>-->

			</xsl:element>
		</xsl:for-each>
	</xsl:function>


	<!-- Write defines for IO -->
	<xsl:template name="conf:io-defines">
		<xsl:param name="params" />

		<!-- Inputs -->
		<xsl:for-each select="$params[@dir='in']" >
			<xsl:text>#define READ__</xsl:text><xsl:value-of select="@name" /><xsl:text>(x)&#9;(x)=</xsl:text>
			<xsl:value-of select="@read" /> <xsl:text>;&#10;</xsl:text>
		</xsl:for-each>

		<!-- Outputs -->
		<xsl:for-each select="$params[@dir='out']" >
			<xsl:text>#define WRITE__</xsl:text><xsl:value-of select="@name" /><xsl:text>(x)&#9;</xsl:text>
			<xsl:value-of select="@write" /> <xsl:text>(x);&#10;</xsl:text>
		</xsl:for-each>
	</xsl:template>


	<!-- Main function of the program -->
	<xsl:template name="conf:main">
		<xsl:param name="params" />
		<xsl:param name="name" />

		<!-- Start of main -->
		<xsl:text>&#10;&#10;int main()&#10;{&#10;</xsl:text>

		<xsl:for-each select="$params[@active='true']">
			<xsl:text>&#9;ds_active(&amp;SENSOR_</xsl:text>
			<xsl:value-of select="@port" />
			<xsl:text>);&#10;</xsl:text>
		</xsl:for-each>

		<!-- Activate rotation sensors. -->
		<xsl:for-each select="$params[@type = 'rotation']" >
			<xsl:text>&#9;ds_active(&amp;SENSOR_</xsl:text>
			<xsl:value-of select="@port" />
			<xsl:text>);&#10;</xsl:text>

			<xsl:text>&#9;ds_rotation_on(&amp;SENSOR_</xsl:text>
			<xsl:value-of select="@port" />
			<xsl:text>);&#10;</xsl:text>

			<!-- Initialize to 0 -->
			<xsl:text>&#9;ds_rotation_set(&amp;SENSOR_</xsl:text>
			<xsl:value-of select="@port" />
			<xsl:text>, 0);&#10;</xsl:text>
		</xsl:for-each>

		<!-- Call loop function. -->
		<xsl:text>&#9;</xsl:text><xsl:value-of select="$name" /><xsl:text>();&#10;</xsl:text>

		<!-- return 0; -->
		<xsl:text>&#9;return 0;&#10;}&#10;</xsl:text>
	</xsl:template>

</xsl:stylesheet>
