#include <conio.h>
#include <unistd.h>
#include <dbutton.h>
#include <dsensor.h>
#include <dmotor.h>
#include <sys/tm.h>
#include <rom/system.h>

#include <robot.h>

int light_1;
int light_2;
int light_3;
int motor_a_s;
int motor_a_d;
int motor_b_s;
int motor_b_d;
int motor_c_s;
int motor_c_d;


void handle_inputs()
{
	light_1 = LIGHT_1;
	light_2 = LIGHT_2;
	light_3 = LIGHT_3;
}


void handle_outputs()
{
	motor_a_speed( motor_a_s );
	motor_a_dir( motor_a_d );
	motor_b_speed( motor_b_s );
	motor_b_dir( motor_b_d );
	motor_c_speed( motor_c_s );
	motor_c_dir( motor_c_d );
}


int main()
{
	ds_active(&SENSOR_1);
	ds_active(&SENSOR_2);
	ds_active(&SENSOR_3);
	handle_inputs();
	robot_init( light_1, light_2, light_3, &motor_a_s, &motor_a_d, &motor_b_s, &motor_b_d, &motor_c_s, &motor_c_d );

	handle_outputs();

	while( 1 )
	{
		msleep(10);

		handle_inputs();
		robot_step( light_1, light_2, light_3, &motor_a_s, &motor_a_d, &motor_b_s, &motor_b_d, &motor_c_s, &motor_c_d );
		handle_outputs();
	}
	return 0;
}
